#pragma once
#ifndef FACE_H_
#define FACE_H_

#include <XFaceApp/ApplicationBase.h>
#include "ScriptProcessorLoader.h"

class View;
namespace XFaceApp
{
	class Face : public ApplicationBase
	{
		View* _view;
		
		bool createScriptProcessors();
		ScriptProcessorLoader m_scriptProcLoader;
		boost::shared_ptr<ISound> createSound() const;
		boost::shared_ptr<XEngine::ITimer> createTimer() const;
		boost::shared_ptr<XFace::FaceBase> createFace() const;
		boost::shared_ptr<XEngine::IRenderer> createRenderer() const;
		boost::shared_ptr<XFace::IFapStream> createFapStream() const;
		boost::shared_ptr<IScriptProcessor> getScriptProcessor(const std::string& name) const;
		bool yield();
		void renderBegin() const;
		void renderEnd() const;

	protected:
		void fireNotification(const Notification& note) const{};

	public:
		bool init();
		bool processTask();
		void newTask(const Task& task);
		void onRenderFrame() const;
		Face(View* view);
	};
} // namespace XFaceApp

#endif //FACE_H_